//Listing 12.7. Klasa kontenera z pamici przydzielan dynamicznie
#include <iostream>
using namespace std;

#include <iostream> // dynamiczny kontener rozmiaru zmiennej
using namespace std;

class Sample { // klasa komponentu
  double value; // warto prbki
public:
  Sample (double x = 0) // konstruktor domylny oraz konwertujcy
    { value = x; }
  void set (double x) // metoda modyfikatora
    { value = x; }
  double get () const // metoda selektora
    { return value; } } ;

class History { // klasa kontenera: ustaw warto
  int size, count, idx;
  Sample *data;
public:
  History() : size(3), count(0), idx(0) // wyczy tablic
  { data = new Sample[size]; // przydziel nowy obszar
    if (data == NULL)
       { cout << " Brak pamici\n"; exit(1); } }
  void add(double); // dodaj prbk na kocu
  Sample& getComponent() // zwr referencj do obiektu klasy Sample
  { return data[idx]; } // moe by komunikatem obiektu docelowego
  void getFirst()
  { idx = 0; }
  bool getNext()
  { return ++idx < count; }
  void average () const; // wywietl redni
  ~History() { delete [ ] data; } // zwolnij pami przydzielon dynamicznie
} ;

void History::add(double s)
{ if (count == size)
  { size = size * 2; // zwiksz obszar dwukrotnie
      Sample *p = new Sample[size];
    if (p == NULL)
      { cout << " Brak pamici\n"; exit(1); } // sprawd powodzenie operacji
    for (int i=0; i < count; i++)
      p[i] = data[i]; // przekopiuj istniejce elementy
    delete [ ] data; // usu istniejc tablic
    data = p; // zastp j now tablic
    cout << " nowy rozmiar: " << size << endl; } // komunikat testowy
    data[count++].set(s); } // uyj kolejny dostepny obszar

void History::average () const
{ cout << "\n Warto rednia: ";
  double sum = 0;
  for (int i = 0; i < count; i++)
    sum += data[i].get();
  cout << sum/count << endl; }

int main()
{ double a[] = {3, 5, 7, 11, 13, 17, 19, 23, 29 } ; // dane wejciowe
  History h;
  for (int i=0; i < 9; i++)
    h.add(a[i]); // dodaj histori
  cout << "\n Historia pomiarw:" << endl << endl;
  h.getFirst(); // zadanie jest przekazywane dalej
  do {
    cout << " " << h.getComponent().get(); // wywietl kady komponent
    } while (h.getNext());
  h.average();
  return 0;
  }
